/*
 * 쐬: 2008/08/05
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFEclipse Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ext.s2jdbc.ui;

import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jface.wizard.Wizard;

import zigen.plugin.db.ext.s2jdbc.Activator;

public class DtoWizard extends Wizard {
	
	
	private DtoWizardPage page1;
	
	private String name;
	
	private PackageFragment pkg;
	
	private boolean checkInterface;
	
	private boolean checkBase;
	
	private boolean checkImpl;
	
	private boolean checkVo;
	
	private boolean checkTest;
	
	private String tableName; // TablegĂꍇ̂
	
	public DtoWizard() {
		super();
		setNeedsProgressMonitor(true);
	}
	
	
	public DtoWizard(String tableName) {
		this();
		this.tableName = tableName;
	}
	
	public void addPages() {
		
		if (tableName != null) {
			page1 = new DtoWizardPage(tableName);
		} else {
			page1 = new DtoWizardPage();
		}
		addPage(page1);
		
	}
	
	public boolean performFinish() {
		try {
			this.name = page1.getNameText().getText();
			// this.checkImpl = page1.getCheckImpl().getSelection();
			// this.checkBase = page1.getCheckBase().getSelection();
			// this.checkInterface = page1.getCheckInterface().getSelection();
			// this.checkVo = page1.getCheckVo().getSelection();
			// this.checkTest = page1.getCheckTest().getSelection();
			this.pkg = page1.getPackageFragment();
			
			return true;
		} catch (Exception e) {
			Activator.getDefault().showErrorDialog(e);
			return false;
		}
		
	}
	
	// I[o[Ch
	public boolean canFinish() {
		if (page1.isPageComplete()) {
			return true;
		} else {
			return false;
		}
	}
	
	public boolean isCheckImpl() {
		return checkImpl;
	}
	
	public boolean isCheckBase() {
		return checkBase;
	}
	
	public boolean isCheckInterface() {
		return checkInterface;
	}
	
	public boolean isCheckTest() {
		return checkTest;
	}
	
	public boolean isCheckVo() {
		return checkVo;
	}
	
	public PackageFragment getPackageFragment() {
		return pkg;
	}
	
	public String getName() {
		return name;
	}
	
	public void setTableName(String tableName) {
		this.tableName = tableName;
	}
	

}
